% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bso-phenology.R
\name{bso_translate_phenology}
\alias{bso_translate_phenology}
\title{Translate BSO generated phenology}
\usage{
bso_translate_phenology(pheno, threshold = 0.1, .quiet = FALSE)
}
\arguments{
\item{pheno}{A BSO phenology (see \code{\link[=bso_phenology]{bso_phenology()}})}

\item{threshold}{Share of individuals that must have reached a specific
development in the BSO phenology to account for them in the corresponding
standard phenology.}

\item{.quiet}{If \code{TRUE}, messages are suppressed.}
}
\value{
Returns a standard phenology as a list. Look \link[=analyse.phenology]{here} to find out how
a phenology can be analysed. It is not recommended to access the list elements directly.
}
\description{
A BSO generated phenology cannot be analysed in the same way as other phenology objects.
To be able to use the functions that are available for phenology objects
returned by \code{\link[=phenology]{phenology()}}, the BSO generated phenology should be translated.
}
\examples{
\donttest{
# This may take a few minutes...

# calculate and translate BSO phenology
p <- bso_phenology('bso', barrks_data('stations'), .quiet = TRUE)
pt <- bso_translate_phenology(p, .quiet = TRUE)

# print the generations data frame of station 'Freiburg'
df <- get_generations_df(pt, 'Freiburg')
df
}
}
