% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barry-package.R
\docType{package}
\name{barry-package}
\alias{barry}
\alias{barry-package}
\title{barry: 'C++' Headers for the 'barry' Library}
\description{
Provides 'C++' header-only files for the 'barry' library, which is a template
library for counting sufficient statistics on binary arrays and building
discrete exponential-family models. The 'barry' library includes tools for
sparse arrays, user-defined count statistics, support set constraints,
power set generation, and modules for Discrete Exponential Family Models
(DEFMs) and network statistics.
}
\details{
This package follows the same approach as the 'BH' package which provides
'Boost' headers for R. To use 'barry' in your R package, add \code{LinkingTo: barry}
to your DESCRIPTION file. The headers will then be available for inclusion
in your 'C++' code via \verb{#include <barry/barry.hpp>}.

The 'barry' library was created by Dr. George G. Vega Yon as part of his
doctoral dissertation and provides a general framework for building discrete
exponential-family models, particularly useful for Exponential Random Graph
Models (ERGMs) and other network statistics.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/USCbiostats/barryr}
  \item \url{https://uscbiostats.github.io/barryr/}
  \item Report bugs at \url{https://github.com/USCbiostats/barryr/issues}
}

}
\author{
\strong{Maintainer}: George Vega Yon \email{g.vegayon@gmail.com} (\href{https://orcid.org/0000-0002-3171-0844}{ORCID})

}
\keyword{internal}
