% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain_bartMachine.R
\name{Explain.bartMachine}
\alias{Explain.bartMachine}
\title{Approximate Shapley Values Computed from a BART Model Fitted using \code{bartMachine}}
\usage{
\method{Explain}{bartMachine}(
  object,
  feature_names = NULL,
  X = NULL,
  nsim = 1,
  pred_wrapper = NULL,
  newdata = NULL,
  parallel = FALSE,
  ...
)
}
\arguments{
\item{object}{A BART model (Bayesian Additive Regression Tree) estimated
using the \code{bartMachine} function from the \pkg{bartMachine}.}

\item{feature_names}{The name of the variable for which you want to check the contribution.
The default value is set to \code{NULL}, which means the contribution of all variables in \code{X} will be calculated.}

\item{X}{The dataset containing all independent variables used as input when estimating the BART model. Categorical or character variables must not contain an underscore ("_") in their values or labels.}

\item{nsim}{The number of Monte Carlo repetitions used for estimating each Shapley value is set to \code{1} by default for the BART model.}

\item{pred_wrapper}{A function used to estimate the predicted values of the model.}

\item{newdata}{New data containing the variables included in the model.
This is used when checking the contribution of newly input data using the model.
The default value is set to \code{NULL}, meaning that the input \code{X} data,
i.e., the data used for model estimation, will be used by default.}

\item{parallel}{The default value is set to \code{FALSE},
but it can be changed to \code{TRUE} for parallel computation.}

\item{...}{Additional arguments to be passed}
}
\value{
An object of class \code{ExplainbartMachine} with the following components :
\item{phis}{A list containing the Shapley values for each variable.}
\item{newdata}{The data used to check the contribution of variables. If a variable has categories, categorical variables are one-hot encoded.}
\item{fnull}{The expected value of the model's predictions.}
\item{fx}{The prediction value for each observation.}
\item{factor_names}{The name of the categorical variable. If the data contains only continuous or dummy variables, it is set to \code{NULL}.}
}
\description{
This function is used to calculate the contribution of each variable
in the Bayesian Additive Regression Trees (BART) model using permutation.
It is used to compute the Shapley values of models estimated 
using the \code{bartMachine} function from the \pkg{bartMachine}.
}
\examples{
\donttest{
## Friedman data
set.seed(2025)
n <- 200
p <- 5
X <- data.frame(matrix(runif(n * p), ncol = p))
y <- 10 * sin(pi* X[ ,1] * X[,2]) +20 * (X[,3] -.5)^2 + 10 * X[ ,4] + 5 * X[,5] + rnorm(n)

##  Using the bartMachine 
model <- bartMachine::bartMachine(X, y, seed = 2025, num_iterations_after_burn_in =200 )

## prediction wrapper function
pfun <- function (object, newdata) {
  bartMachine::bart_machine_get_posterior(object,newdata) $ y_hat_posterior_samples
  }
  
## Calculate shapley values
model_exp <-  Explain  ( model, X = X,  pred_wrapper =  pfun )
}
}
