% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heteroscedasticity_test.R
\name{heteroscedasticity_test}
\alias{heteroscedasticity_test}
\alias{var_test_b}
\title{Test for heteroscedasticity in AOV models}
\usage{
heteroscedasticity_test(hetero_model, homo_model)
}
\arguments{
\item{hetero_model}{aov_b object where the heteroscedastic argument
has been set to TRUE (the default)}

\item{homo_model}{aov_b object where the heteroscedastic argument
has been set to FALSE}
}
\value{
(returned invisible) A tibble with Bayes factors and interpretations.
}
\description{
Use Chib's method to compute the Bayes factor to test for
heteroscedasticity in analysis of variance models.
}
\examples{
\donttest{
# Test homoscedastic case
## Generate some data
set.seed(2025)
N = 200
test_data = 
  data.frame(x1 = rep(letters[1:5],N/5))
test_data$outcome = 
  rnorm(N,-1 + 2 * (test_data$x1 \%in\% c("d","e")) )

## Fit the anova models
hetero_model = 
  aov_b(outcome ~ x1,
        test_data)
homo_model = 
  aov_b(outcome ~ x1,
        test_data,
        heteroscedastic = FALSE)

## Perform test for heteroscedasticity using Bayes factors
heteroscedasticity_test(hetero_model,
                        homo_model)

# Test heteroscedastic case
## Generate some data
set.seed(2025)
N = 200
test_data = 
  data.frame(x1 = rep(letters[1:5],N/5))
test_data$outcome = 
  rnorm(N,
        -1 + 2 * (test_data$x1 \%in\% c("d","e")),
        sd = 3 - 2 * (test_data$x1 \%in\% c("d","e")))

## Fit the anova models
hetero_model = 
  aov_b(outcome ~ x1,
        test_data)
homo_model = 
  aov_b(outcome ~ x1,
        test_data,
        heteroscedastic = FALSE)

## Perform test for heteroscedasticity using Bayes factors
heteroscedasticity_test(hetero_model,
                        homo_model)
}


}
\references{
Kass, R. E., & Raftery, A. E. (1995). Bayes Factors. Journal of the American Statistical Association, 90(430), 773–795.
}
