% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation_helper_functions.R
\name{get_MAP}
\alias{get_MAP}
\title{Find the maximum a posteriori (MAP) estimate of the MCMC chain}
\usage{
get_MAP(dat, nburn)
}
\arguments{
\item{dat}{A data frame where each row holds the log marginal likelihood
values at each iteration of the MCMC chain.}

\item{nburn}{numeric. The size of the burn-in phase after which the MAP
estimate will be identified.}
}
\value{
A numeric vector of iterations at which the MAP estimate was found
  for each animal ID.
}
\description{
Identify the MCMC iteration that holds the MAP estimate. This will be used to
inform \code{\link{get_breakpts}} as to which breakpoints should be retained
on which to assign track segments to the observations of each animal ID.
}
\examples{
\donttest{
#load data
data(tracks.list)

#subset only first track
tracks.list<- tracks.list[1]

#only retain id and discretized step length (SL) and turning angle (TA) columns
tracks.list2<- purrr::map(tracks.list,
                   subset,
                  select = c(id, SL, TA))


set.seed(1)

# Define model params
alpha<- 1
ngibbs<- 1000
nbins<- c(5,8)

#future::plan(future::multisession)  #run all MCMC chains in parallel
dat.res<- segment_behavior(data = tracks.list2, ngibbs = ngibbs, nbins = nbins,
                           alpha = alpha)


# Determine MAP iteration for selecting breakpoints and store breakpoints
MAP.est<- get_MAP(dat = dat.res$LML, nburn = ngibbs/2)
}

}
