% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps.R
\name{prop_scr_hist}
\alias{prop_scr_hist}
\title{Histogram of the Propensity Score Object}
\usage{
prop_scr_hist(
  x,
  variable = c("propensity score", "ps", "inverse probability weight", "ipw"),
  ...
)
}
\arguments{
\item{x}{Propensity score object}

\item{variable}{Variable to plot. It must be either a propensity score
("ps" or "propensity score") or inverse probability weight ("ipw" or
"inverse probability weight")}

\item{...}{Optional arguments for \code{geom_histogram}}
}
\value{
ggplot object
}
\description{
Plot overlapping histograms of the propensity scores for both
the internal and external participants, or plot external IPWs.
}
\examples{
library(dplyr)
ps_obj <- calc_prop_scr(internal_df = filter(int_norm_df, trt == 0),
                       external_df = ex_norm_df,
                       id_col = subjid,
                       model = ~ cov1 + cov2 + cov3 + cov4)
# Plotting the Propensity Scores
prop_scr_hist(ps_obj)
# Or plotting the inverse probability weights
prop_scr_hist(ps_obj, variable = "ipw")
}
