% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_confounds.R
\name{plot.bids_confounds}
\alias{plot.bids_confounds}
\title{Plot PCA confounds}
\usage{
\method{plot}{bids_confounds}(
  x,
  view = c("auto", "run", "aggregate"),
  pcs = NULL,
  top_n = 8,
  max_panels = 6,
  ...
)
}
\arguments{
\item{x}{A \code{bids_confounds} object returned by \code{read_confounds()}.}

\item{view}{Character. One of \code{"auto"}, \code{"run"}, or
\code{"aggregate"}.}

\item{pcs}{Integer or character vector of PCs to plot (e.g., \code{1:5}
or \code{c("PC1", "PC2")}).}

\item{top_n}{Integer. Keep the top \code{top_n} variables per PC based on
absolute loading. Set to \code{NULL} to keep all variables.}

\item{max_panels}{Integer. In \code{view = "auto"}, facet score plots only
when the number of runs is at most \code{max_panels}.}

\item{...}{Unused.}
}
\value{
A ggplot object, or a list of ggplot objects when patchwork is not
available.
}
\description{
Visualize principal component scores and loadings returned by
\code{read_confounds(..., npcs = ...)}. When multiple runs are present,
the default view facets per run for scores (up to \code{max_panels}) and
aggregates loadings across runs.
}
\examples{
\donttest{
parts <- c("01", "02")
fs <- tibble::tibble(
  subid = rep(c("01", "02"), each = 2),
  datatype = "func",
  suffix = rep(c("bold.nii.gz", "desc-confounds_timeseries.tsv"), 2),
  task = "rest", fmriprep = TRUE
)
conf_data <- list()
for (p in parts) {
  key <- paste0("derivatives/fmriprep/sub-", p,
                "/func/sub-", p, "_task-rest_desc-confounds_timeseries.tsv")
  conf_data[[key]] <- data.frame(
    csf = rnorm(100), white_matter = rnorm(100),
    global_signal = rnorm(100), framewise_displacement = abs(rnorm(100)),
    trans_x = rnorm(100), trans_y = rnorm(100), trans_z = rnorm(100),
    rot_x = rnorm(100), rot_y = rnorm(100), rot_z = rnorm(100)
  )
}
mock <- create_mock_bids("ConfPlot", parts, fs, confound_data = conf_data)
conf <- read_confounds(mock, npcs = 3)
if (requireNamespace("ggplot2", quietly = TRUE)) {
  plot(conf)
}
}
}
