% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glasso.R
\name{regul_glasso}
\alias{regul_glasso}
\title{Regularization with the graphical lasso}
\usage{
regul_glasso(
  mat,
  lambda,
  maxiter_outer = 200,
  maxiter_lasso = 200,
  tol = 1e-04,
  verbose = FALSE
)
}
\arguments{
\item{mat}{A square symmetric matrix.}

\item{lambda}{Strength of regularization. It needs to be scaled with \code{mat}.
It should also be the maximum difference between the two matrices.}

\item{maxiter_outer}{Maximum number of iterations of the outer loop.
Default is 200.}

\item{maxiter_lasso}{Maximum number of iterations of each lasso solver.
Default is 200.}

\item{tol}{Tolerance for assessing convergence. Default is 1e-4 and it needs
to be scaled with \code{mat}.}

\item{verbose}{Whether to print iterations and differences. Default is FALSE.}
}
\value{
The regularized matrix, where the diagonal should be the same and
zeros should be kept as well. It also returns the \code{lambda} used as an attribute.
}
\description{
Use the graphical lasso algorithm to regularize a square symmetric matrix
(e.g. a covariance or correlation matrix) by assuming that its inverse has
many zeros.
}
\examples{
(cov <- cov(iris[1:4]))
lambda <- 1 / sqrt(nrow(iris))
(cov_regul <- regul_glasso(cov, lambda))
}
