% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtReg.R
\name{gtRegControl}
\alias{gtRegControl}
\title{Auxiliary for controlling group testing regression}
\usage{
gtRegControl(
  tol = 1e-04,
  n.gibbs = 1000,
  n.burnin = 20,
  maxit = 500,
  trace = FALSE,
  time = TRUE
)
}
\arguments{
\item{tol}{convergence criterion.}

\item{n.gibbs}{the Gibbs sample size to be used in each E step
of the EM algorithm, for array testing. The default is 1000.}

\item{n.burnin}{the number of samples in the burn-in period,
for array testing. The default is 20.}

\item{maxit}{maximum number of iterations in the EM algorithm.}

\item{trace}{a logical value indicating whether the output should
be printed for each iteration. The default is \kbd{FALSE}.}

\item{time}{a logical value indicating whether the length of time
for the model fitting should be printed. The default is \kbd{TRUE}.}
}
\value{
A list with components named as the input arguments.
}
\description{
Auxiliary function to control fitting parameters
of the EM algorithm used internally in \code{\link{gtReg}}
for simple pooling (\kbd{type = "sp"}) with \kbd{method = "Xie"}
or for array testing (\kbd{type = "array"}).
}
\examples{
# The default settings:
gtRegControl()
}
\author{
This function was originally written as the \code{gt.control}
function for the binGroup package. Minor modifications have been
made for inclusion in the binGroup2 package.
}
