% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.LeakTune}
\alias{summary.LeakTune}
\title{Summarize a nested tuning result}
\usage{
\method{summary}{LeakTune}(object, digits = 3, ...)
}
\arguments{
\item{object}{A [LeakTune] object returned by [tune_resample()].}

\item{digits}{Integer scalar. Number of decimal places to print in numeric
summary tables. Defaults to 3.}

\item{...}{Unused. Included for S3 method compatibility.}
}
\value{
Invisibly returns `object$metric_summary`, the data frame of per-learner
  metric means and standard deviations computed across outer folds.
}
\description{
Prints a concise report for a `LeakTune` object produced by [tune_resample()].
The report highlights the tuning strategy, selection metric, and
cross-validated performance across outer folds, plus a glimpse of the selected
hyperparameters.
}
