% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmamba.R
\name{appmamba}
\alias{appmamba}
\alias{install_appmamba}
\alias{uninstall_appmamba}
\alias{appmamba_rc}
\title{Manage Environment with \code{micromamba}}
\usage{
appmamba(...)

install_appmamba(force = FALSE)

uninstall_appmamba()

appmamba_rc(edit = FALSE)
}
\arguments{
\item{...}{<\link[rlang:dyn-dots]{dynamic dots}> Additional arguments passed to
\code{micromamba}. Run \code{appmamba()} for more details.}

\item{force}{A logical value indicating whether to reinstall \code{appmamba}
if it is already installed.}

\item{edit}{A logical value indicating whether to open the config file for
editing.}
}
\description{
Manage Environment with \code{micromamba}
}
\section{Functions}{
\itemize{
\item \code{appmamba()}: \code{blit} utilizes \code{micromamba} to manage environments.
This function simply executes the specified \code{micromamba} command.

\item \code{install_appmamba()}: Install appmamba (\code{micromamba}).

\item \code{uninstall_appmamba()}: Remove appmamba (\code{micromamba}).

\item \code{appmamba_rc()}: Get the \verb{run commands} config file of the \code{micromamba}.

}}
\examples{
install_appmamba()
appmamba()
appmamba("env", "list")
# uninstall_appmamba() # Uninstall the `micromamba`
}
