% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import-functions.R
\name{boilerplate_save}
\alias{boilerplate_save}
\title{Save boilerplate Database}
\usage{
boilerplate_save(
  db,
  category = NULL,
  data_path = NULL,
  format = "json",
  confirm = TRUE,
  create_dirs = FALSE,
  quiet = FALSE,
  pretty = TRUE,
  timestamp = FALSE,
  entry_level_confirm = TRUE,
  create_backup = NULL,
  select_elements = NULL,
  output_file = NULL,
  project = "default"
)
}
\arguments{
\item{db}{List. The database to save. Can be a single category database or unified database.}

\item{category}{Character. The category name if saving a single category.
If NULL and db contains multiple categories, saves as unified database.}

\item{data_path}{Character. Base path for data directory.
If NULL (default), uses tools::R_user_dir("boilerplate", "data").}

\item{format}{Character. Format to save: "json" (default), "rds", or "both".}

\item{confirm}{Logical. If TRUE, asks for confirmation. Default is TRUE.}

\item{create_dirs}{Logical. If TRUE, creates directories if they don't exist. Default is FALSE.}

\item{quiet}{Logical. If TRUE, suppresses all CLI alerts. Default is FALSE.}

\item{pretty}{Logical. If TRUE (default), pretty-print JSON for readability.}

\item{timestamp}{Logical. If TRUE, add timestamp to filename. Default is FALSE.}

\item{entry_level_confirm}{Logical. Not used, kept for backward compatibility.}

\item{create_backup}{Logical. If TRUE, creates a backup before saving. Default is TRUE unless running examples or in a temporary directory.}

\item{select_elements}{Character vector. Not used, kept for backward compatibility.}

\item{output_file}{Character. Not used, kept for backward compatibility.}

\item{project}{Character. Project name for organizing databases. Default is "default".
Projects are stored in separate subdirectories to allow multiple independent
boilerplate collections.}
}
\value{
Invisible TRUE if successful, with saved file paths as an attribute.
}
\description{
This function saves a boilerplate database to disk in RDS, JSON, or both formats.
}
\examples{
# Create a temporary directory
temp_dir <- tempdir()
data_path <- file.path(temp_dir, "boilerplate_save_example", "data")

# Create a test database
test_db <- list(
  methods = list(
    sample = list(default = "Sample text")
  ),
  measures = list(
    test_measure = list(name = "Test", description = "A test measure")
  )
)

# Save as unified database
boilerplate_save(
  db = test_db,
  data_path = data_path,
  create_dirs = TRUE,
  confirm = FALSE,
  quiet = TRUE
)

# Check that file was created
file.exists(file.path(data_path, "boilerplate_unified.rds"))

# Save a single category
boilerplate_save(
  db = test_db$methods,
  category = "methods",
  data_path = data_path,
  confirm = FALSE,
  quiet = TRUE
)

# Clean up
unlink(file.path(temp_dir, "boilerplate_save_example"), recursive = TRUE)

}
