% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/communicability.R
\name{centr_betw_comm}
\alias{centr_betw_comm}
\title{Calculate communicability betweenness centrality}
\usage{
centr_betw_comm(g, A = NULL)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{A}{Numeric matrix; the adjacency matrix of the input graph. Default:
\code{NULL}}
}
\value{
A numeric vector of the centrality for each vertex
}
\description{
\code{centr_betw_comm} calculates the \emph{communicability betweenness} of
the vertices of a graph. The centrality for vertex \code{r} is
\deqn{\omega_r = \frac{1}{C} \sum_p \sum_q \frac{(e^{\mathbf{A}})_{pq} -
(e^{\mathbf{A} + \mathbf{E}(r)})_{pq}}{(e^{\mathbf{A}})_{pq}}}
where \eqn{C = (n - 1)^2 - (n - 1)} is a normalization factor.
}
\references{
Estrada, E. and Higham, D.J. and Hatano N. (2009) Communicability
  betweenness in complex networks. \emph{Physica A}, \bold{388}, 764--774.
  \doi{10.1016/j.physa.2008.11.011}
}
\seealso{
Other Centrality functions: 
\code{\link{centr_lev}()}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Centrality functions}
