% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_bundeshaushalt.R
\name{bundeshaushalt_budget_data}
\alias{bundeshaushalt_budget_data}
\title{Query Bundeshaushalt budget data}
\usage{
bundeshaushalt_budget_data(
  params = list(),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{params}{Query parameters.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with budget data and nested detail lists.

Includes \code{timestamp_time} as POSIXct in Europe/Berlin.
}
\description{
Query Bundeshaushalt budget data
}
\details{
The Bundeshaushalt API provides budget data for federal income and expenses.
Required query parameters are \code{year} and \code{account}. Official docs:
https://github.com/bundesAPI/bundeshaushalt-api.
}
\examples{
\dontrun{
bundeshaushalt_budget_data(params = list(year = 2021, account = "expenses"))
}

}
