% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_lebensmittelwarnung.R
\name{lebensmittelwarnung_warnings}
\alias{lebensmittelwarnung_warnings}
\title{List food and product warnings}
\usage{
lebensmittelwarnung_warnings(
  food = list(),
  products = list(),
  safe = TRUE,
  refresh = FALSE,
  flatten = FALSE,
  flatten_mode = "json"
)
}
\arguments{
\item{food}{Optional request options for food warnings (rows, start, sort, fq).}

\item{products}{Optional request options for product warnings (rows, start, sort, fq).}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble with warning entries.

Includes \code{published_date_time} as POSIXct in Europe/Berlin.
}
\description{
List food and product warnings
}
\details{
The Lebensmittelwarnungen API returns German food and product safety warnings.
Requests are sent as JSON to the \code{warnings/merged} endpoint. Official docs:
https://lebensmittelwarnung.api.bund.dev and
https://github.com/bundesAPI/lebensmittelwarnung-api.

The API expects an \code{Authorization} header. By default the adapter uses the
public key documented in the OpenAPI spec. Override it with
\code{\link[=bunddev_auth_set]{bunddev_auth_set()}} if needed.
}
\examples{
\dontrun{
lebensmittelwarnung_warnings(food = list(rows = 10), products = list(rows = 0))
}

}
\seealso{
\code{\link[=bunddev_auth_set]{bunddev_auth_set()}} to configure the authorization header.
}
