% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egyptian.R
\name{egyptian_date}
\alias{egyptian_date}
\alias{armenian_date}
\alias{as_egyptian}
\alias{as_armenian}
\title{Egyptian and Armenian calendar dates}
\usage{
egyptian_date(year = integer(), month = integer(), day = integer())

armenian_date(year = integer(), month = integer(), day = integer())

as_egyptian(date)

as_armenian(date)
}
\arguments{
\item{year}{Numeric vector of years}

\item{month}{Numeric vector of months}

\item{day}{Numeric vector of days}

\item{date}{Vector of dates on some calendar}
}
\value{
An egyptian or armenian vector object
}
\description{
The ancient Egyptian calendar is a 365-day solar calendar with 12 months of 30 days each, plus a 13th month of 5 days.
The Armenian calendar is similar but has a different epoch and month names.
}
\examples{
tibble::tibble(
  gregorian = gregorian_date(2025, 5, 1:10),
  egyptian = as_egyptian(gregorian),
  armenian = as_armenian(gregorian)
)
}
