% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_camtrapdp.R
\name{merge_camtrapdp}
\alias{merge_camtrapdp}
\title{Merge two Camera Trap Data Packages}
\usage{
merge_camtrapdp(x, y)
}
\arguments{
\item{x, y}{Camera Trap Data Package objects, as returned by
\code{\link[=read_camtrapdp]{read_camtrapdp()}}.}
}
\value{
A single Camera Trap Data Package object that is the combination of
\code{x} and \code{y}.
}
\description{
Merges two Camera Trap Data Package objects into one.
Repeat to merge multiple datasets.
}
\section{Transformation details}{


Both \code{x} and \code{y} must have a unique dataset name \code{x$name} and \code{y$name}.
This name is used to prefix identifiers in the data that occur in both
datasets.
For example:
\itemize{
\item \code{x} contains \code{deploymentID}s \code{c("a", "b")}.
\item \code{y} contains \code{deploymentID}s \code{c("b", "c")}.
\item Then merged \code{xy} will contain \code{deploymentID}s \code{c("a", "x_b", "y_b", "c")}.
}

Data are merged as follows:
\itemize{
\item Deployments are combined, with \code{deploymentID} kept unique.
\item Media are combined, with \code{mediaID}, \code{deploymentID} and \code{eventID} kept
unique.
\item Observations are combined, with \code{observationID}, \code{deploymentID}, \code{mediaID}
and \code{eventID} kept unique.
\item Additional resources are retained, with the resource name kept unique.
}

Metadata properties are merged as follows:
\itemize{
\item \strong{name}: Removed.
\item \strong{id}: Removed.
\item \strong{created}: Set to current timestamp.
\item \strong{title}: Removed.
\item \strong{contributors}: Combined, with duplicates removed.
\item \strong{description}: Combined as two paragraphs.
\item \strong{version}: Set to \code{1.0}.
\item \strong{keywords}: Combined, with duplicates removed.
\item \strong{image}: Removed.
\item \strong{homepage}: Removed.
\item \strong{sources}: Combined, with duplicates removed.
\item \strong{licenses}: Combined, with duplicates removed.
\item \strong{bibliographicCitation}: Removed.
\item \strong{project$id}: Removed.
\item \strong{project$title}: Combined.
\item \strong{project$acronym}: Removed.
\item \strong{project$description}: Combined as two paragraphs.
\item \strong{project$path}: Removed.
\item \strong{project$samplingDesign}: Sampling design of \code{x}.
\item \strong{project$captureMethod}: Combined, with duplicates removed.
\item \strong{project$individuals}: \code{TRUE} if one of the datasets has \code{TRUE}.
\item \strong{project$observationLevel}: Combined, with duplicates removed.
\item \strong{coordinatePrecision}: Set to the least precise \code{coordinatePrecision}.
\item \strong{spatial}: Reset based on the new deployments.
\item \strong{temporal}: Reset based on the new deployments.
\item \strong{taxonomic}: Combined, with duplicates removed.
\item \strong{relatedIdentifiers}: Combined, with duplicates removed.
\item \strong{references}: Combined, with duplicates removed.
\item Custom properties of \code{x} are also retained.
}
}

\examples{
x <- example_dataset() \%>\%
  filter_deployments(deploymentID \%in\% c("00a2c20d", "29b7d356"))
y <- example_dataset() \%>\%
  filter_deployments(deploymentID \%in\% c("577b543a", "62c200a9"))
x$name <- "x"
y$name <- "y"
merge_camtrapdp(x, y)
}
\seealso{
Other transformation functions: 
\code{\link{round_coordinates}()},
\code{\link{shift_time}()},
\code{\link{update_taxon}()},
\code{\link{write_dwc}()},
\code{\link{write_eml}()}
}
\concept{transformation functions}
