% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CARA_function.R
\name{ZhaoNew_Sim_Surv}
\alias{ZhaoNew_Sim_Surv}
\title{Simulation Function for Zhao's New Design for Survival Trial}
\usage{
ZhaoNew_Sim_Surv(
  n,
  mu,
  beta,
  gamma,
  m0 = 40,
  pts.X,
  pts.Z,
  censor.time,
  arrival.rate,
  omega,
  p = 0.8
)
}
\arguments{
\item{n}{a positive integer. The sample size of the simulated data.}

\item{mu}{a number. The true parameters of treatment.}

\item{beta}{a vector of length 2. The true parameters of predictive covariate and interaction with treatment.}

\item{gamma}{a vector of length k. The true parameters of prognostic covariates.}

\item{m0}{a positive integer. The number of first 2m0 patients will be allocated equally to both treatments.}

\item{pts.X}{a vector of length n. The vector of patients' binary predictive covariates.Must be binary.}

\item{pts.Z}{a matrix of \code{n x k}. The matrix of patients' binary prognostic covariates.Must be binary.}

\item{censor.time}{a positive number. The upper bound of the uniform censor time in year.}

\item{arrival.rate}{a positive integer. The arrival rate of patients each year.}

\item{omega}{a vector of length \code{2+k}. The weight of imbalance.}

\item{p}{a positive value between 0.75 and 0.95. The probability parameter of Efron's biased coin design.}
}
\value{
A list with the following elements:
\item{method}{The name of procedure.}
\item{sampleSize}{The sample size of the trial.}
\item{assignment}{The randomization sequence.}
\item{X1proportion}{Average allocation proportion for treatment A when predictive covariate equals the smaller value.}
\item{X2proportion}{Average allocation proportion for treatment A when predictive covariate equals the larger value.}
\item{proportion}{Average allocation proportion for treatment A.}
\item{N.events}{Total number of events occured of the trial.}
\item{responses}{Observed survival responses of patients.}
\item{events}{Survival status vector of patients(1=event,0=censored)}
\item{rejectNull}{Logical. Indicates whether the treatment effect is statistically significant based on a Wald test.}
}
\description{
This function simulates a clinical trial using Zhao's New design for survival responses.
}
\examples{
set.seed(123)

# Simulation settings
n = 400                    # total number of patients
m0 = 40                    # initial burn-in sample size
mu = 0.5           # potential means (for continuous or logistic link)
beta = c(1, 1)             # treatment effect and predictive covariate effect
gamma = c(0.1, 0.5)        # prognostic covariate effects
omega = rep(0.25, 4)       # imbalance weights
p = 0.8                    # biased coin probability
censor.time = 2            # maximum censoring time
arrival.rate = 150         # arrival rate of patients
# Generate patient covariates
pts.X = sample(c(1, -1), n, replace = TRUE)  # predictive covariate
pts.Z = cbind(
  sample(c(1, -1), n, replace = TRUE),        # prognostic Z1
  sample(c(1, -1), n, replace = TRUE)         # prognostic Z2
)

# Run the simulation (binary response setting)
result = ZhaoNew_Sim_Surv(
  n = n,
  mu = mu,
  beta = beta,
  gamma = gamma,
  m0 = m0,
  pts.X = pts.X,
  pts.Z = pts.Z,
  omega = omega,
  p = p,
  censor.time = censor.time,
  arrival.rate = arrival.rate
)

}
\concept{Zhao's New Design}
