% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construction_emissions.R
\name{construction_emissions}
\alias{construction_emissions}
\title{Calculate construction emissions (UK govt schema)}
\usage{
construction_emissions(
  use = stats::setNames(numeric(), character()),
  waste = TRUE,
  material_production = c("Primary material production", "Re-used", "Closed-loop source"),
  waste_disposal = c("Closed-loop", "Combustion", "Composting", "Landfill", "Open-loop"),
  units = c("kg", "tonnes"),
  value_col = c("value", "value_2024"),
  strict = TRUE
)
}
\arguments{
\item{use}{Named numeric vector of material quantities in tonnes.
Names are matched case/space/punctuation-insensitively to \verb{Level 3}
(e.g., \code{"Mineral oil"}, \code{"mineral_oil"}, \code{"MINERAL-OIL"} all match).
Missing/unknown materials are treated as zero.}

\item{waste}{Logical. If \code{TRUE}, waste quantities are assumed equal to \code{use}
(i.e., the same tonnage is sent to the chosen disposal route).
If \code{FALSE}, no waste is applied (equivalent to zero for all materials).}

\item{material_production}{Either:
\itemize{
\item a single string applied to all materials, e.g.
\code{"Primary material production"}, \code{"Closed-loop source"}, or \code{"Re-used"}; or
\item a named character vector giving a choice per material name,
e.g. \code{c(concrete = "Closed-loop source", wood = "Re-used")}.
Synonyms are accepted for material production: \code{"reused"/"re-used"},
\code{"closed loop"/"closed-loop"/"closed-loop source"}.
}}

\item{waste_disposal}{One of \code{"Closed-loop"}, \code{"Combustion"}, \code{"Composting"},
\code{"Landfill"}, or \code{"Open-loop"}. Applied to all waste. If the chosen
disposal route is not available for a material, behaviour depends on \code{strict}.}

\item{units}{Output units: \code{"kg"} (default) or \code{"tonnes"}.}

\item{value_col}{Which factor column to use from \code{uk_gov_data}: \code{"value"} or \code{"value_2024"}.}

\item{strict}{Logical (default \code{TRUE}). If \code{TRUE}, error when a required factor
is missing/invalid for any nonzero quantity (either material use or waste).
If \code{FALSE}, treat missing factors as zero contribution.}
}
\value{
Numeric total emissions in the requested \code{units}.
}
\description{
Computes embodied GHG emissions for construction materials using the
UK government conversion factors table (\code{uk_gov_data}), specifically rows
with Level 2 = "Construction". Factors are taken from the selected
column (\code{value} or \code{value_2024}) and are assumed to be kg CO2e per tonne.
}
\details{
Material-production options (Column Text under Material use):
\itemize{
\item Aggregates, Asphalt: \code{"Primary material production"}, \code{"Closed-loop source"}, \code{"Re-used"}.
\item Asbestos, Average Construction, Bricks: \code{"Primary material production"} only.
\item Concrete, Insulation, Metals, Mineral Oil, Plasterboard:
\code{"Primary material production"} or \code{"Closed-loop source"}.
\item Soils: \code{"Closed-loop source"} only.
\item Tyres, Wood: \code{"Primary material production"} or \code{"Re-used"}.
}

Waste-disposal options (Column Text under Waste disposal):
\itemize{
\item \code{"Closed-loop"} is valid for aggregates, average, asphalt, concrete,
insulation, metal, soils, mineral oil, plasterboard, tyres, wood.
\item \code{"Combustion"} is valid for average, mineral oil, wood.
\item \code{"Composting"} is valid for wood only.
\item \code{"Landfill"} is valid for everything except average, mineral oil, tyres.
\item \code{"Open-loop"} is valid for aggregates, average, asphalt, bricks, concrete
(and any other materials where the table provides a factor).
}

These rules are enforced by the presence/absence of rows in \code{uk_gov_data}. If a
requested material-route pair has no factor in the table, the lookup yields \code{NA}:
with \code{strict = TRUE} a descriptive error is thrown; with \code{strict = FALSE} it
contributes zero to the total.

Units: Factors are kg CO2e / tonne; if \code{units = "tonnes"}, the result
is divided by 1000.
}
\examples{
# 1) Basic: primary production for all materials, landfill waste = use
construction_emissions(
  use = c(Aggregates = 1000, Concrete = 500, Wood = 2000),
  material_production = "Primary material production",
  waste_disposal = "Landfill",
  waste = TRUE,
  strict = FALSE,
  units = "kg"
)

# 2) Per-material production + synonyms ("closed loop" ->
# "Closed-loop source", "reused" -> "Re-used")
construction_emissions(
  use = c(aggregates = 100, concrete = 50, wood = 10),
  material_production = c(aggregates = "closed loop",
                          concrete = "Closed-loop source",
                          wood = "reused"),
  waste_disposal = "Landfill",
  waste = TRUE,
  units = "tonnes",
  value_col = "value_2024"
)

# 3)  Tolerant mode treats missing factors as zero:
construction_emissions(
  use = c(bricks = 10),
  material_production = "Re-used",
  strict = FALSE
)
}
