% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caugi_to.R
\name{as_adjacency}
\alias{as_adjacency}
\title{Convert a caugi to an adjacency matrix}
\usage{
as_adjacency(x)
}
\arguments{
\item{x}{A \code{caugi} object.}
}
\value{
An integer 0/1 adjacency matrix with row/col names.
}
\description{
Does not take other edge types than the one found in a PDAG.
}
\examples{
cg <- caugi(
  A \%-->\% B,
  class = "DAG"
)
adj <- as_adjacency(cg)

}
\seealso{
Other conversions: 
\code{\link{as_bnlearn}()},
\code{\link{as_caugi}()},
\code{\link{as_dagitty}()},
\code{\link{as_igraph}()}
}
\concept{conversions}
