% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operations.R
\name{skeleton}
\alias{skeleton}
\title{Get the skeleton of a graph}
\usage{
skeleton(cg)
}
\arguments{
\item{cg}{A \code{caugi} object. Either a DAG or PDAG.}
}
\value{
A \code{caugi} object representing the skeleton of the graph (UG).
}
\description{
The skeleton of a graph is obtained by replacing all directed edges with
undirected edges.
}
\details{
This changes the graph from any class to an Undirected Graph (UG), also known
as a Markov Graph.
}
\examples{
cg <- caugi(A \%-->\% B, class = "DAG")
skeleton(cg) # A --- B

}
\seealso{
Other operations: 
\code{\link{moralize}()},
\code{\link{mutate_caugi}()}
}
\concept{operations}
