% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_vector.R
\name{new_logical}
\alias{new_logical}
\alias{new_integer}
\alias{new_double}
\alias{new_character}
\alias{new_complex}
\alias{new_raw}
\title{Fast multi-threaded vector initialisation}
\usage{
new_logical(n = 0L, names = NULL, default = FALSE)

new_integer(n = 0L, names = NULL, default = 0L)

new_double(n = 0L, names = NULL, default = 0)

new_character(n = 0L, names = NULL, default = "")

new_complex(n = 0L, names = NULL, default = complex(real = 0, imaginary = 0))

new_raw(n = 0L, names = NULL, default = as.raw(0))
}
\arguments{
\item{n}{\verb{[integer(1)]} - Length of vector.}

\item{names}{\verb{[character(n)]} - Names of initialised vector.}

\item{default}{Default value to initialise the vector with.}
}
\value{
New vector.
}
\description{
Fast multi-threaded vector initialisation
}
\seealso{
\link{new_list}
}
