% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_valid_var}
\alias{assert_valid_var}
\alias{assert_valid_var.character}
\alias{assert_valid_var.factor}
\alias{assert_valid_var.logical}
\alias{assert_valid_var.numeric}
\alias{assert_valid_var.POSIXct}
\alias{assert_valid_var.default}
\title{Check whether var is valid}
\usage{
assert_valid_var(x, label, na_ok, empty_ok, ...)

\method{assert_valid_var}{character}(
  x,
  label = deparse(substitute(x)),
  na_ok = FALSE,
  empty_ok = FALSE,
  min_chars = 1L,
  ...
)

\method{assert_valid_var}{factor}(
  x,
  label = deparse(substitute(x)),
  na_ok = FALSE,
  empty_ok = FALSE,
  min_chars = 1L,
  ...
)

\method{assert_valid_var}{logical}(
  x,
  label = deparse(substitute(x)),
  na_ok = TRUE,
  empty_ok = FALSE,
  ...
)

\method{assert_valid_var}{numeric}(
  x,
  label = deparse(substitute(x)),
  na_ok = TRUE,
  empty_ok = FALSE,
  integerish = FALSE,
  ...
)

\method{assert_valid_var}{POSIXct}(
  x,
  label = deparse(substitute(x)),
  na_ok = TRUE,
  empty_ok = FALSE,
  tzs = OlsonNames(),
  ...
)

\method{assert_valid_var}{default}(
  x,
  label = deparse(substitute(x)),
  na_ok = FALSE,
  empty_ok = FALSE,
  ...
)
}
\arguments{
\item{x}{value of col_split variable}

\item{label}{(\code{string}) hints.}

\item{na_ok}{(\code{flag}) whether NA value is allowed}

\item{empty_ok}{(\code{flag}) whether length 0 value is allowed.}

\item{...}{Further arguments to methods.}

\item{min_chars}{(\code{integer}) the minimum length of the characters.}

\item{integerish}{(\code{flag}) whether the number should be treated as \code{integerish}.}

\item{tzs}{(\code{character}) time zones.}
}
\value{
invisible \code{NULL} or an error message if the criteria are not fulfilled.
}
\description{
Check whether var is valid
}
\details{
This function checks the variable values are valid or not.
}
