% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call_rainbow.R
\name{call_rainbow}
\alias{call_rainbow}
\title{Call 'rainbow' parsers
Parse 'Agilent' or 'Waters' files with rainbow parsers}
\usage{
call_rainbow(
  path,
  format_in = c("agilent_d", "waters_raw", "masshunter", "chemstation", "chemstation_uv",
    "chemstation_fid"),
  format_out = c("matrix", "data.frame", "data.table"),
  data_format = c("wide", "long"),
  by = c("detector", "name"),
  what = NULL,
  read_metadata = TRUE,
  metadata_format = c("chromconverter", "raw"),
  collapse = TRUE,
  precision = 1
)
}
\arguments{
\item{path}{Path to file.}

\item{format_in}{Format of the supplied files. Either \code{agilent_d},
\code{waters_raw}, or \code{chemstation}.}

\item{format_out}{R format. Either \code{matrix}, \code{data.frame}, or
\code{data.table}.}

\item{data_format}{Whether to return data in wide or long format.}

\item{by}{How to order the list that is returned. Either \code{detector}
(default) or \code{name}.}

\item{what}{What types of data to return (e.g. \code{MS}, \code{UV}, \code{CAD},
\code{ELSD}). This argument only applies if \code{by == "detector"}.}

\item{read_metadata}{Logical. Whether to attach metadata. Defaults to TRUE.}

\item{metadata_format}{Format to output metadata. Either \code{chromconverter}
or \code{raw}.}

\item{collapse}{Logical. Whether to collapse lists that only contain a single
element.}

\item{precision}{Number of decimals to round mz values. Defaults to 1.}
}
\value{
Returns a (nested) list of \code{matrices} or \code{data.frames} according to
the value of \code{format_out}. Data is ordered according to the value of
\code{by}.
}
\description{
Uses \href{https://rainbow-api.readthedocs.io}{rainbow} parsers to read in Agilent (.D)
and Waters (.raw) files. If \code{format_in} is \code{"agilent_d"} or
\code{"waters_raw"}, a directory of the appropriate format (\code{.d} or
\code{.raw}) should be provided to the \code{file} argument. If \code{format_in} is
\code{"chemstation_uv"} a \code{.uv} file should be provided. Data can be filtered
by detector type using the \code{what} argument.
}
\seealso{
Other external parsers: 
\code{\link{call_entab}()},
\code{\link{call_openchrom}()},
\code{\link{read_thermoraw}()},
\code{\link{sp_converter}()},
\code{\link{uv_converter}()}
}
\author{
Ethan Bass
}
\concept{external parsers}
