% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_chemstation_ch.R
\name{read_agilent_dx}
\alias{read_agilent_dx}
\title{Read 'Agilent' DX files}
\usage{
read_agilent_dx(
  path,
  path_out = NULL,
  format_out = c("matrix", "data.frame", "data.table"),
  data_format = c("wide", "long"),
  read_metadata = TRUE
)
}
\arguments{
\item{path}{Path to \code{.dx} file.}

\item{path_out}{Path to directory to export unzipped files.}

\item{format_out}{Class of output. Either \code{matrix}, \code{data.frame},
or \code{data.table}.}

\item{data_format}{Whether to return data in \code{wide} or \code{long} format.}

\item{read_metadata}{Logical. Whether to attach metadata.}
}
\value{
A chromatogram in the format specified by \code{format_out}
(retention time x wavelength).
}
\description{
Reads 'Agilent' \code{.dx} files.
}
\details{
This function unzips 'Agilent'  \code{.dx} into a temporary directory using
\code{\link{unzip}} and calls \code{\link{read_chemstation_ch}}.
}
\seealso{
Other 'Agilent' parsers: 
\code{\link{read_agilent_d}()},
\code{\link{read_chemstation_ch}()},
\code{\link{read_chemstation_csv}()},
\code{\link{read_chemstation_ms}()},
\code{\link{read_chemstation_reports}()},
\code{\link{read_chemstation_uv}()}
}
\author{
Ethan Bass
}
\concept{'Agilent' parsers}
