% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_shimadzu_lcd.R
\name{read_shimadzu_lcd}
\alias{read_shimadzu_lcd}
\title{Read 'Shimadzu' LCD}
\usage{
read_shimadzu_lcd(
  path,
  what,
  format_out = c("matrix", "data.frame", "data.table"),
  data_format = c("wide", "long"),
  read_metadata = TRUE,
  metadata_format = c("chromconverter", "raw"),
  scale = TRUE,
  collapse = TRUE
)
}
\arguments{
\item{path}{Path to 'Shimadzu' \code{.lcd} file.}

\item{what}{What stream to get: current options are \code{pda}, chromatograms
(\code{chroms}), \code{tic}, or peak lists (\code{peak_table}). If a stream
is not specified, the function will default to \code{pda} if the PDA stream
is present.}

\item{format_out}{Matrix or data.frame.}

\item{data_format}{Either \code{wide} (default) or \code{long}.}

\item{read_metadata}{Logical. Whether to attach metadata. Defaults to \code{TRUE}.}

\item{metadata_format}{Format to output metadata. Either \code{chromconverter}
or \code{raw}.}

\item{scale}{Whether to scale the data by the value factor. Defaults to
\code{TRUE}.}

\item{collapse}{Logical. Whether to collapse lists that only contain a single
element.}
}
\value{
A chromatogram or list of chromatograms in the format specified by
\code{data_format} and \code{format_out}. If \code{data_format} is \code{wide},
the chromatogram(s) will be returned with retention times as rows and a
single column for the intensity. If \code{long} format is requested, two
columns will be returned: one for the retention time and one for the intensity.
The \code{format_out} argument determines whether chromatograms are returned
as a \code{matrix}, \code{data.frame}, or \code{data.table}. Metadata can be
attached to the chromatogram as \code{\link{attributes}} if
\code{read_metadata} is \code{TRUE}.
}
\description{
Read 3D PDA or 2D chromatogram streams from 'Shimadzu' \code{.lcd} files.
}
\details{
A parser to read data from 'Shimadzu' \code{.lcd} files. LCD files are
encoded as 'Microsoft' OLE documents. The parser relies on the
\href{https://pypi.org/project/olefile/}{olefile} package in Python to unpack the
files. The PDA data is encoded in a stream called \code{PDA 3D Raw Data:3D Raw Data}.
The PDA data stream contains a segment for each retention time, beginning
with a 24-byte header.

The 24 byte header consists of the following fields:
\itemize{
\item 4 bytes: segment label (\code{17234}).
\item 4 bytes: Little-endian integer specifying the sampling rate along the time
axis for 2D streams or along the spectral axis (?) for PDA streams.
\item 4 bytes: Little-endian integer specifying the number of values in the file
(for 2D data) or the number of wavelength values in each segment (for 3D data).
\item 4 bytes: Little-endian integer specifying the total number of bytes in the segment.
\item 8 bytes of \code{00}.
}

For 3D data, Each time point is divided into two sub-segments, which begin and
end with an integer specifying the length of the sub-segment in bytes. 2D data
are structured similarly but with more segments. All known values
in this the LCD data streams are little-endian and the data are delta-encoded.
The first hexadecimal digit of each value is a sign digit specifying the
number of bytes in the delta and whether the value is positive
or negative. The sign digit represents the number of hexadecimal digits used
to encode each value. Even numbered sign digits correspond to positive deltas,
whereas odd numbers indicate negative deltas. Positive values are encoded as
little-endian integers, while negative values are encoded as two's
complements. The value at each position is derived by subtracting the delta
at each position from the previous value.
}
\note{
My parsing of the date-time format seems to be a little off, since
the acquisition times diverge slightly from the ASCII file.
}
\examples{
\dontrun{
read_shimadzu_lcd(path)
}
}
\seealso{
Other 'Shimadzu' parsers: 
\code{\link{read_shimadzu}()},
\code{\link{read_shimadzu_gcd}()},
\code{\link{read_shimadzu_qgd}()},
\code{\link{read_sz_lcd_2d}()},
\code{\link{read_sz_lcd_3d}()}
}
\author{
Ethan Bass
}
\concept{'Shimadzu' parsers}
