% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_waters_raw.R
\name{read_waters_raw}
\alias{read_waters_raw}
\title{Read 'Waters' RAW}
\usage{
read_waters_raw(
  path,
  format_out = c("matrix", "data.frame", "data.table"),
  data_format = c("wide", "long"),
  read_metadata = TRUE,
  metadata_format = c("chromconverter", "raw")
)
}
\arguments{
\item{path}{Path to Waters \code{.raw} file.}

\item{format_out}{Class of output. Either \code{matrix}, \code{data.frame},
or \code{data.table}.}

\item{data_format}{Either \code{wide} (default) or \code{long}.}

\item{read_metadata}{Logical. Whether to attach metadata.}

\item{metadata_format}{Format to output metadata. Either \code{chromconverter}
or \code{raw}.}
}
\value{
A chromatogram in the format specified by \code{format_out}
(retention time x wavelength).
}
\description{
Reads 'Waters MassLynx' (\code{.raw}) files into R.
}
\note{
For now this parser only reads 1D chromatograms (not mass spectra or
DAD data) and does not support parsing of metadata from 'Waters' RAW files.
}
\seealso{
Other 'Waters' parsers: 
\code{\link{read_waters_arw}()}
}
\author{
Ethan Bass
}
\concept{'Waters' parsers}
