% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncons.R
\name{uncons}
\alias{uncons}
\title{Unconstrained model}
\usage{
uncons(object)
}
\arguments{
\item{object}{Fitted 'cirls' object.}
}
\value{
A \code{cirls} object.
}
\description{
Takes a fitted \code{cirls} object and returns the corresponding unconstrained model.
}
\details{
\subsection{Note on starting values}{

If any starting values were provided to fit the \code{cirls} object, they are not transferred to the fitting of the unconstrained model.
}
}
\examples{
# Generate some data
n <- 1000
betas <- c(0, 1, 2, -1, 1)
p <- length(betas)
x <- matrix(rnorm(n * p), n, p)
eta <- 5 + x \%*\% betas
y <- eta + rnorm(n, 0, .2)

# Fit two cirls models, passing Cmat through the two different pathways
cinc <- diff(diag(p))
res1 <- glm(y ~ x, method = cirls.fit, Cmat = list(x = cinc))
res2 <- glm(y ~ x, method = cirls.fit, control = list(Cmat = list(x = cinc)))

# 'Unconstrain' the models
uc1 <- uncons(res1)
uc2 <- uncons(res2)

}
