% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wgdev.R
\name{wgdev}
\alias{wgdev}
\title{Calculate within group deviance.}
\usage{
wgdev(covar, groupvar)
}
\arguments{
\item{covar}{Continuous variable for which within group deviance will be calculated.
Please specify the dataset in which the variable is found (i.e. data$var).}

\item{groupvar}{Grouping variable within which deviance will be calculated.
For example, individual ID or site/plot ID. Please specify the dataset in which
the variable is found (i.e. data$var).}
}
\value{
Returns a vector containing numeric values. This can be used to
differentiate within and between group effects in a model. 
See function \code{\link{wgmean}} to calculate within group means.
See van de Pol and Wright 2009 for more detail.
}
\description{
Calculate within group deviance of a variable. Used to test for 'within individual effects'.
See methods outlined in van de Pol and Wright 2009 for more detail.
}
\examples{
# Calculate within year deviance in temperature from the MassClimate dataset.  

data(MassClimate)

#Calculate year column
library(lubridate)
MassClimate$Year <- year(as.Date(MassClimate$Date, format = "\%d/\%m/\%Y"))

#Calculate within year deviance of temperature
within_yr_dev <- wgdev(MassClimate$Temp, MassClimate$Year)

#Add this variable to the original dataset
MassClimate$Within_yr_dev <- within_yr_dev
             
}
\author{
Martijn van de Pol and Jonathan Wright
}
