\name{c_peptide_glucose_ratio}
\alias{c_peptide_glucose_ratio}
\title{
C-Peptide-Glucose Ratio (CPGR)
}
\description{
Calculates the C-Peptide-Glucose Ratio (CPGR), a metric used to estimate endogenous beta-cell function. This ratio helps differentiate between clinical forms of diabetes, particularly distinguishing Type 1 Diabetes (insulin deficiency) from Type 2 Diabetes or Maturity Onset Diabetes of the Young (MODY) (insulin resistance/preservation).
}
\usage{
c_peptide_glucose_ratio(c_peptide, glucose,
                        c_peptide_units = "ng/mL",
                        glucose_units = "mg/dL")
}
\arguments{
  \item{c_peptide}{
Numeric. Fasting C-Peptide level.
}
  \item{glucose}{
Numeric. Fasting Plasma Glucose level.
}
  \item{c_peptide_units}{
String. Units for C-Peptide. Options: "ng/mL" (default), "nmol/L", or "pmol/L".
}
  \item{glucose_units}{
String. Units for Glucose. Options: "mg/dL" (default) or "mmol/L".
}
}
\details{
The ratio is calculated using the formula:
\deqn{CPGR = \frac{C\text{-}Peptide (ng/mL)}{Glucose (mg/dL)} \times 100}

While cutoffs vary by study and specific clinical question (e.g., distinguishing HNF1A-MODY from T1DM), a value of 1.7 or higher is often cited as an indicator of preserved beta-cell function indicative of T2DM or MODY.
}
\value{
A list containing:
\item{CPGR_Score}{The calculated ratio.}
\item{Interpretation}{Clinical suggestion based on a standard cutoff of 1.7.}
}
\references{
Besser RE, Shields BM, anatole S, et al. Differentiation of Type 1 diabetes, Type 2 diabetes and MODY using C-peptide. Diabetes Care. 2011;34:e53.
}
\examples{

# Example 1: Type 1 Diabetes (Low C-Peptide relative to Glucose)
# C-Pep 0.5 ng/mL, Glucose 200 mg/dL
# Ratio = (0.5 / 200) * 100 = 0.25
c_peptide_glucose_ratio(0.5, 200)

# Example 2: Type 2 Diabetes / Insulin Resistance
# C-Pep 4.0 ng/mL, Glucose 150 mg/dL
# Ratio = (4.0 / 150) * 100 = 2.67
c_peptide_glucose_ratio(4.0, 150)
}
