% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_silhoutte.R
\name{compute_silhouette}
\alias{compute_silhouette}
\title{Compute Average Silhouette Width}
\usage{
compute_silhouette(sil)
}
\arguments{
\item{sil}{A silhouette object as returned by \code{\link[cluster]{silhouette}}.}
}
\value{
A numeric value indicating the average silhouette width, or \code{NA} if input is \code{NULL}.
}
\description{
Calculates the average silhouette coefficient from a silhouette object.
}
\examples{
data <- scale(iris[, 1:4])
cl <- kmeans(data, 3)$cluster
sil <- cluster::silhouette(cl, dist(data))
if (interactive()) {
  compute_silhouette(sil)
}


}
