% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_data.R
\name{prepare_data}
\alias{prepare_data}
\title{Prepare Built-in Datasets for Clustering}
\usage{
prepare_data(dataset)
}
\arguments{
\item{dataset}{A string specifying the dataset name. Options are: "iris", "USArrests", "mtcars", "CO2", "swiss", "Moons".}
}
\value{
A cleaned \code{data.frame} containing only numeric variables and no missing values.
}
\description{
Loads and preprocesses a built-in dataset for clustering analysis.
Depending on the dataset name provided, different cleaning steps are applied.
}
\details{
\describe{
  \item{iris}{The classic iris dataset, excluding the species column.}
  \item{USArrests}{State-wise arrest data. Missing values are removed.}
  \item{mtcars}{Motor trend car data set. No transformation applied.}
  \item{CO2}{CO2 uptake in grass plants. Only numeric columns are selected and rows with missing values are removed.}
  \item{swiss}{Swiss fertility and socio-economic indicators. Used as-is.}
  \item{Moons}{Synthetic non-linear dataset generated by \code{mlbench::mlbench.smiley()}.}
}
}
\examples{
data <- prepare_data("iris")
head(data)

}
