% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rkgcpp}
\alias{rkgcpp}
\title{Sample Kolmogorov-Gamma random variables}
\usage{
rkgcpp(n, b, c)
}
\arguments{
\item{n}{The number of samples.}

\item{b}{First parameter, positive integer (1,2,...). Length must be 1 or n.}

\item{c}{Second parameter, real, associated with tilting. Length must be 1 or n.}
}
\value{
It returns n independent Kolmogorov-Gamma(\code{b[i]},\code{c[i]}) samples. If input b or c is scalar, it is assumed to be length n vector with same entries.
}
\description{
A random variable \eqn{X} follows Kolmogorov-Gamma(b,c) distribution, in short KG(b,c), if
\deqn{
 X \stackrel{d}{=} \dfrac{1}{2\pi^2}\sum_{k=1}^\infty \dfrac{\epsilon_k}{k^2 + c^2/(4\pi^2)}, \quad \epsilon_k\stackrel{iid}{\sim} Gamma(b,1)
}
where \eqn{\stackrel{d}{=}} denotes equality in distribution.
The random variate generation is based on alternating series method, a fast and exact method (without infinite sum truncation) implemented in cpp.
This function only supports integer b, which is sufficient for cobin and micobin regression models.
}
\examples{
\donttest{
rkgcpp(100, 1, 2)
rkgcpp(100, 1, rnorm(100))
rkgcpp(100, rep(c(1,2),50), rnorm(100))
}
}
