% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{statistitian_time}
\alias{statistitian_time}
\title{A statistician’s time budget}
\format{
An object of class \code{data.frame} with 20 rows and 7 columns.
}
\usage{
statistitian_time
}
\description{
Time budgets –how a day or a period of work is divided up into different
activities have become a popular source of data in psychology and
sociology. To illustrate such problems we consider six daily activities
undertaken by an academic statistician: teaching (T); consultation (C);
administration (A); research (R); other wakeful activities (O); and sleep (S).

The `statistician_time` data set records the daily time (in hours) devoted
to each activity, recorded on each of 20 days, selected randomly from working days
in alternate weeks so as to avoid possible carry-over effects such as a short-sleep
day being compensated by make-up sleep on the succeeding day. The six activities
may be divided into two categories: 'work' comprising activities T, C, A, and R, and
'leisure', comprising activities O and S. Our analysis may then be directed towards
the work pattern consisting of the relative times spent in the four work activities,
the leisure pattern, and the division of the day into work time and leisure time.
Two obvious questions are as follows. To what extent, if any, do the patterns of
work and of leisure depend on the times allocated to these major divisions of the
day? Is the ratio of sleep to other wakeful activities dependent on the times spent
in the various work activities?
}
\keyword{datasets}
