% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose.R
\name{chain}
\alias{chain}
\title{Chain Solvers with Early Stopping}
\usage{
chain(..., early_stop = NULL)
}
\arguments{
\item{...}{Solver functions to chain}

\item{early_stop}{Optional function that takes a result and returns TRUE
to stop the chain early. Default is NULL (no early stopping).}
}
\value{
A new solver function that runs solvers in sequence
}
\description{
Chains multiple solvers sequentially with optional early stopping.
More flexible than \code{\%>>\%} operator.
}
\details{
The chain runs solvers in order, passing each result's \code{theta.hat}
to the next solver. If \code{early_stop} is provided and returns TRUE
for any intermediate result, the chain stops early.

Common early stopping conditions:
\itemize{
  \item Stop when converged: \code{function(r) r$converged}
  \item Stop when gradient is small: \code{function(r) sqrt(sum(score^2)) < 1e-6}
  \item Stop after reaching target: \code{function(r) r$loglike > -100}
}
}
\examples{
# Chain with early stopping when converged
strategy <- chain(
  grid_search(lower = c(-10, 0.1), upper = c(10, 5), n = 5),
  gradient_ascent(max_iter = 50),
  newton_raphson(max_iter = 20),
  early_stop = function(r) isTRUE(r$converged)
)

# Standard chain (no early stopping)
strategy <- chain(gradient_ascent(), newton_raphson())

}
