% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose.R
\name{race_operator}
\alias{race_operator}
\alias{\%|\%}
\title{Parallel Solver Racing (Operator)}
\usage{
s1 \%|\% s2
}
\arguments{
\item{s1}{First solver function}

\item{s2}{Second solver function}
}
\value{
A new solver function that runs both and picks the best
}
\description{
Runs multiple solvers and returns the best result (highest log-likelihood).
Useful when unsure which method will work best for a given problem.
}
\details{
For parallel execution or more than 2 solvers, use \code{\link{race}}.
}
\examples{
# Race gradient-based vs derivative-free
strategy <- gradient_ascent() \%|\% nelder_mead()

# Race multiple methods
strategy <- gradient_ascent() \%|\% bfgs() \%|\% nelder_mead()

}
\seealso{
\code{\link{race}} for parallel execution
}
