% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conf.R
\name{conf}
\alias{conf}
\title{Perform Confidence Run}
\usage{
conf(x = NULL, tmpdir = tempfile(pattern = "confidence"), browse = TRUE)
}
\arguments{
\item{x}{name of the input file or a \code{\link{data.frame}} containing the 
input. If \code{x = \link{NULL}} (the default) a file dialog will 
appear for interactive selection of an input file. See the package 
vignette for details about the file format.}

\item{tmpdir}{directory to store temporary files (for debugging only)}

\item{browse}{load resulting report directly in a browser? \code{TRUE} or \code{FALSE}}
}
\description{
This function starts the `confidence tool`. The results will be stored 
in a subdirectory in the current working directory. See details section
below.
}
\details{
This function will create a subdirectory

\itemize{
    \item{in the same directory as \code{x}, in case \code{x} is a filename or}
    \item{in the current working directory (see \code{\link{getwd}}), in case 
        \code{x} is a \code{\link{data.frame}}}.
}
The computer should have write permission to this directory, if not
an error message will be raised. The
subdirectory contains an HTML-report with all analysis results. 
For convenience, the results are also stored in CSV-format (tables) 
and png-format (figures) for further processing.
}
\seealso{
\link{confidence} and the package vignette 
   (\code{vignette("confidence")}).
}
