% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crs_report.R
\name{cong_crs_report}
\alias{cong_crs_report}
\title{Request Congressional Research Service (CRS) Report Information}
\usage{
cong_crs_report(
  crs_id = NULL,
  from_date = NULL,
  to_date = NULL,
  limit = 20,
  offset = 0,
  format = "json",
  clean = TRUE
)
}
\arguments{
\item{crs_id}{Optional CRS identifier. If provided, returns a specific report.}

\item{from_date}{Start date for search, e.g. \code{'2022-01-01'}. Optional.}

\item{to_date}{End date for search, e.g. \code{'2022-01-31'}. Optional.}

\item{limit}{Number of records to return. Default is 20. Will be truncated to between 1 and 250.}

\item{offset}{Number of records to skip. Default is 0. Must be non-negative.}

\item{format}{Output format for \code{clean = FALSE}. One of \code{'json'} or \code{'xml'}.}

\item{clean}{Should output be returned as a tibble (\code{TRUE}) or requested format (\code{FALSE}). Default is \code{TRUE}.}
}
\value{
A \code{tibble::tibble} or raw HTTP response if \code{clean = FALSE}.
}
\description{
Request Congressional Research Service (CRS) Report Information
}
\examples{
\dontshow{if (congress::has_congress_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Requires API Key

cong_crs_report()

cong_crs_report(crs_id = '93-792')
\dontshow{\}) # examplesIf}
}
