% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_config.R
\name{list_datasources}
\alias{list_datasources}
\title{Extract data sources from connectors}
\usage{
list_datasources(connectors)
}
\arguments{
\item{connectors}{An object containing connectors with a "datasources" attribute.}
}
\value{
An object containing the data sources extracted from the "datasources" attribute.
}
\description{
This function extracts the "datasources" attribute from a connectors object.
}
\details{
The function uses the \code{attr()} function to access the "datasources" attribute
of the \code{connectors} object. It directly returns this attribute without any
modification.
}
\examples{

# Connectors object with data sources
cnts <- connectors(
  sdtm = connector_fs(path = tempdir()),
  adam = connector_dbi(drv = RSQLite::SQLite())
)

# Using the function (returns datasources attribute)
result <- list_datasources(cnts)
# Check if result contains datasource information
result$datasources

}
