% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covercorr.R
\name{coverage_correlation}
\alias{coverage_correlation}
\title{Coverage-based Dependence Measure with Optional Visualisation}
\usage{
coverage_correlation(
  x,
  y,
  visualise = FALSE,
  method = c("auto", "exact", "approx"),
  M = NULL,
  na.rm = TRUE
)
}
\arguments{
\item{x}{Numeric vector or matrix.}

\item{y}{Numeric vector or matrix with the same number of rows as \code{x}.}

\item{visualise}{Logical; if \code{TRUE}, displays a scatter plot of the
rank-transformed points with overlaid rectangles to illustrate the coverage
calculation. The default is \code{FALSE} (no plot). If set to \code{TRUE}
but either \code{x} or \code{y} has more than one column, a warning is
issued and \code{visualise} is reset to \code{FALSE}.}

\item{method}{Character string specifying the computation method. Options are \code{"auto"}, \code{"exact"}, or \code{"approx"}. See Details.}

\item{M}{Integer; Number of Monte Carlo integration sample points (used when \code{method = "approx"}). Optional.}

\item{na.rm}{Logical; if \code{TRUE}, remove \code{NA} values before computation.}
}
\value{
A list with four elements:
\itemize{
\item \code{stat} – The numeric value of the coverage correlation coefficient.
\item \code{pval} – The p-value, calculated using the exact variance under the null hypothesis of independence between \code{x} and \code{y}.
\item \code{method} – A character string indicating the computation method used.
\item \code{mc_se} – A numeric value. If method "approx" was used \code{mc_se} is the standard error of the Monte Carlo approximation, otherwise it is 0.
}
}
\description{
Computes the coverage correlation coefficient between input \code{x} and \code{y}, as introduced in \href{https://arxiv.org/abs/2508.06402}{the arXiv preprint}. This coefficient measures the dependence between two random variables or vectors.
}
\details{
The procedure is as follows:
\enumerate{
\item Calculate the rank transformations \eqn{(r_x, r_y)} of the inputs \code{x} and \code{y}.
\item Construct small cubes (in 2D, squares) of volume \eqn{n^{-1}} centered at each rank-transformed point.
\item Compute the total area of the union of these cubes, intersected with \eqn{[0,1]^d} where \eqn{d = d_x + d_y}.
}
The coverage correlation coefficient is then calculated based on this union area.

For more details, please refer to the original paper: \href{https://arxiv.org/abs/2508.06402}{the arXiv preprint}.

The \code{method} argument controls how the computation is performed:
\itemize{
\item \code{"exact"}: Computes the exact value.
\item \code{"approx"}: Uses a Monte Carlo approximation with \code{M} sample points.
\item \code{"auto"}: Automatically selects a method based on the total number of columns in \code{x} and \code{y}: if more than 6, \code{"approx"} is used (with \code{M = nrow(x)^{1.5}} if \code{M} is not provided); otherwise, \code{"exact"} is used.
}
}
\examples{
set.seed(1)
n <- 100
x <- runif(n)
y <- sin(3*x) + runif(n) * 0.01
coverage_correlation(x, y, visualise = TRUE)

}
