% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_hierarchical_count_row.R
\name{add_hierarchical_count_row}
\alias{add_hierarchical_count_row}
\title{Add row with counts}
\usage{
add_hierarchical_count_row(
  x,
  label = "Overall total number of events",
  .before = NULL,
  .after = NULL,
  data_preprocess = identity
)
}
\arguments{
\item{x}{(\code{gtsummary})\cr
a gtsummary table}

\item{label}{(\code{string})\cr
label for the new row}

\item{.before, .after}{(\code{integer})\cr
Row index where to add the new row. Default is after last row.}

\item{data_preprocess}{(\code{function} or \code{formula})\cr
a function that is applied to \code{x$inputs$data} before the total row counts
are tabulated. Default is \code{identity}. Tidyverse formula shortcut notation
for the function is accepted. See \code{rlang::as_function()} for details.}
}
\value{
gtsummary table
}
\description{
Typically used to add a row with overall AE counts to a table that primarily
displays AE rates.
}
\examples{
# Example 1 ----------------------------------
cards::ADAE |>
  # subset the data for a shorter example table
  dplyr::slice(1:10) |>
  tbl_hierarchical(
    by = "TRTA",
    variables = AEDECOD,
    denominator = cards::ADSL,
    id = "USUBJID",
    overall_row = TRUE
  ) |>
  add_hierarchical_count_row(.after = 1L)
}
