% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine.R
\name{crossfit}
\alias{crossfit}
\title{Cross-fitting for a single method}
\usage{
crossfit(
  data,
  method,
  fold_split = function(data, K) sample(rep_len(1:K, nrow(data))),
  seed = NULL,
  max_fail = Inf,
  verbose = FALSE
)
}
\arguments{
\item{data}{Data frame or matrix with the observations.}

\item{method}{A single method specification (list) created by
\code{\link{create_method}}. It must contain a \code{target}
function and \code{aggregate_panels} / \code{aggregate_repeats}
must be functions.}

\item{fold_split}{A function producing a K-fold split of the data
(see \code{\link{crossfit_multi}}).}

\item{seed}{Integer base random seed.}

\item{max_fail}{Non-negative integer or \code{Inf} controlling how
many repetitions the method may fail before being disabled.}

\item{verbose}{Logical; if \code{TRUE}, prints a compact status line
per repetition.}
}
\value{
The same structure as \code{\link{crossfit_multi}}, but with
a single method named \code{"method"}. The final estimate is in
\code{$estimates$method}.
}
\description{
Convenience wrapper around \code{\link{crossfit_multi}} for the
common case of a single method. It enforces that \code{method} is a
single method specification and forwards the aggregation functions
stored inside \code{method}.
}
\examples{
set.seed(1)
n <- 100
x <- rnorm(n)
y <- x + rnorm(n)

data <- data.frame(x = x, y = y)

# Nuisance: E[Y | X]
nuis_y <- create_nuisance(
  fit = function(data, ...) lm(y ~ x, data = data),
  predict = function(model, data, ...) predict(model, newdata = data)
)

# Target: mean squared error of the nuisance predictor
target_mse <- function(data, nuis_y, ...) {
  mean((data$y - nuis_y)^2)
}

method <- create_method(
  target = target_mse,
  list_nuisance = list(nuis_y = nuis_y),
  folds = 2,
  repeats = 2,
  eval_fold = 1L,
  mode = "estimate",
  fold_allocation = "independence",
  aggregate_panels  = mean_estimate,
  aggregate_repeats = mean_estimate
)

cf <- crossfit(data, method)
cf$estimates
}
