% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{validate_nuisance}
\alias{validate_nuisance}
\title{Internal: basic structural checks for a single nuisance}
\usage{
validate_nuisance(nf, nm = NULL, mname = NULL)
}
\arguments{
\item{nf}{A list representing a nuisance specification.}

\item{nm}{Optional nuisance name for error messages.}

\item{mname}{Optional method name for error messages.}
}
\value{
A normalized nuisance list with guaranteed components
\code{fit}, \code{predict}, \code{train_fold},
\code{fit_deps}, and \code{pred_deps}.
}
\description{
Performs basic validation and normalization for a single nuisance
specification. This ensures that the nuisance:
\itemize{
\item is a list with \code{fit} and \code{predict} functions,
\item has a valid positive integer \code{train_fold},
\item has \code{fit_deps} and \code{pred_deps} either \code{NULL}
or named character vectors (arg \eqn{\to} nuisance).
}
}
\details{
This function does not infer dependencies or check cycles; that is
done at the method level by \code{validate_method()}.
}
\keyword{internal}
