% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_openinterest.R
\name{get_openinterest}
\alias{get_openinterest}
\title{Get the open interest on perpetual futures contracts}
\usage{
get_openinterest(
 ticker,
 interval = '1d',
 source   = 'binance',
 from     = NULL,
 to       = NULL
)
}
\arguments{
\item{ticker}{A \link{character}-vector of \link{length} 1.
See \code{\link[=available_tickers]{available_tickers()}} for available tickers.}

\item{interval}{A \link{character}-vector of \link{length} 1. \verb{1d} by default.
See \code{\link[=available_intervals]{available_intervals()}} for available intervals.}

\item{source}{A \link{character}-vector of \link{length} 1. \code{binance} by default.
See \code{\link[=available_exchanges]{available_exchanges()}} for available exchanges.}

\item{from}{An optional \link{character}-, \link{date}- or
\link{POSIXct}-vector of \link{length} 1. \link{NULL} by default.}

\item{to}{An optional \link{character}-, \link{date}- or
\link{POSIXct}-vector of \link{length} 1. \link{NULL} by default.}
}
\value{
An <[\link[xts]{xts}]>-object containing,

\item{index}{<\link{POSIXct}> the time-index}
\item{open_interest}{<\link{numeric}> open perpetual contracts on both both sides}

\strong{Sample output}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#>                     open_interest
#> 2024-05-12 02:00:00      70961.07
#> 2024-05-13 02:00:00      69740.49
#> 2024-05-14 02:00:00      71110.33
#> 2024-05-15 02:00:00      67758.06
#> 2024-05-16 02:00:00      73614.70
#> 2024-05-17 02:00:00      72377.85
}\if{html}{\out{</div>}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Get the open interest on a cryptocurrency pair from the
\code{\link[=available_exchanges]{available_exchanges()}} in any actively traded \code{\link[=available_tickers]{available_tickers()}}
on the FUTURES markets.
}
\details{
\subsection{On time-zones and dates}{

Values passed to \verb{from`` or }to\verb{must be coercible by [as.Date()], or [as.POSIXct()], with a format of either}"\%Y-\%m-\%d"\code{or}"\%Y-\%m-\%d \%H:\%M:\%S"`. By default all dates are passed and
returned with \code{\link[=Sys.timezone]{Sys.timezone()}}.
}

\subsection{On returns}{

If only \code{from} is provided 200 pips are returned up to \code{Sys.time()}.
If only \code{to} is provided 200 pips up to the specified date is returned.
}
}
\examples{
\dontrun{
  # script start;

  # 1) check available
  # exchanges for open interest
  cryptoQuotes::available_exchanges(
    type = 'interest'
    )

  # 2) get BTC funding rate
  # for the last 7 days
  tail(
    BTC <- cryptoQuotes::get_openinterest(
      ticker = "BTCUSDT",
      source = "binance",
      from   = Sys.Date() - 7
    )
  )

  # script end;
}

}
\seealso{
Other get-functions: 
\code{\link{get_fgindex}()},
\code{\link{get_fundingrate}()},
\code{\link{get_lsratio}()},
\code{\link{get_quote}()}
}
\author{
Serkan Korkmaz
}
\concept{get-functions}
