% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exposure-APIs.R
\name{get_httk_data}
\alias{get_httk_data}
\title{Get httk data}
\usage{
get_httk_data(
  DTXSID = NULL,
  API_key = NULL,
  Server = exposure_api_server,
  verbose = FALSE
)
}
\arguments{
\item{DTXSID}{The chemical identifier DTXSID}

\item{API_key}{The user-specific API key}

\item{Server}{The root address for the API endpoint}

\item{verbose}{A logical indicating if some "progress report" should be given.}
}
\value{
A data.table of httk data for the given input chemical.
}
\description{
Get httk data
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) withAutoprint(\{ # examplesIf}
# Pull httk data for BPA
bpa_httk <- get_httk_data(DTXSID = 'DTXSID7020182')
\dontshow{\}) # examplesIf}
}
