% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_index.R
\name{get_enc}
\alias{get_enc}
\title{Calculate effective number of codons (ENC)}
\usage{
get_enc(cf, codon_table = get_codon_table(), level = "subfam")
}
\arguments{
\item{cf}{A matrix of codon frequencies as calculated by \code{count_codons()}.
Rows represent sequences and columns represent codons.}

\item{codon_table}{A codon table defining the genetic code, derived from
\code{get_codon_table()} or \code{create_codon_table()}.}

\item{level}{Character string specifying the analysis level: "subfam" (default,
analyzes codon subfamilies) or "amino_acid" (analyzes at amino acid level).}
}
\value{
A named numeric vector of ENC values. Names correspond to sequence
  identifiers from the input matrix. ENC values typically range from 20
  (maximum bias) to 61 (uniform usage).
}
\description{
\code{get_enc} computes the effective number of codons (ENC) for each coding
sequence, which quantifies the degree of codon usage bias. Lower ENC values
indicate stronger bias (fewer codons are used), while higher values indicate
more uniform codon usage.
}
\examples{
# Calculate ENC for yeast genes
cf_all <- count_codons(yeast_cds)
enc <- get_enc(cf_all)
head(enc)
hist(enc, main = "Distribution of ENC values")

}
\references{
Wright F. 1990. The 'effective number of codons' used in a gene. Gene 87:23-29.

Sun X, Yang Q, Xia X. 2013. An improved implementation of effective number of codons (NC). Mol Biol Evol 30:191-196.
}
