% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ringtest_c}
\alias{ringtest_c}
\title{EFSA Ringtest Dataset C}
\format{
An object of class \code{data.frame} with 30 rows and 4 columns.
}
\usage{
ringtest_c
}
\description{
This dataset is part of EFSA's \emph{GUTS} ringtest to compare results from software
implementations of \link[=GUTS-RED-models]{GUTS-RED models} (EFSA 2018). The ringtest
focused on \link[=GUTS_RED_IT]{GUTS-RED-IT} and \link[=GUTS_RED_SD]{GUTS-RED-SD} models.
}
\details{
\emph{Dataset C} in this ringtest came from the work of Geiger et al. (1988) on effects of
\emph{Diazinon} on \emph{fathead minnow}. The dataset contains four columns, identifying the control
and treatment levels, the concentrations in these treatments, the timepoint of measurement
and the number of survivors.
}
\references{
EFSA PPR Panel (EFSA Panel on Plant Protection Products and their Residues),
Ockleford C, Adriaanse P, Berny P, et al., 2018: \emph{Scientific Opinion on the
state of the art of Toxicokinetic/Toxicodynamic (TKTD) effect models for
regulatory risk assessment of pesticides for aquatic organisms}. EFSA Journal 2018;
16(8):5377, 188 pp. \doi{10.2903/j.efsa.2018.5377}

Geiger DL, Call DJ, and Brooke LT, 1988: Acute Toxicities of Organic Chemicals to
Fathead Minnow (\emph{Pimephales promelas}), Vol IV. Center for Lake Superior Environmental
Studies, University of Wisconsin-Superior, Superior, WI, USA.

https://cran.r-project.org/web/packages/GUTS/vignettes/ringTest.html
}
\seealso{
\link{GUTS-RED-models}
}
\keyword{datasets}
