% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed_linear.R
\name{normmix}
\alias{normmix}
\alias{rnormmix}
\alias{pnormmix}
\alias{dnormmix}
\alias{qnormmix}
\title{Density, Distribution, Quantiles and Random Number Generation for the mixed normal
distribution}
\usage{
rnormmix(n, mu, sigma, prop)

dnormmix(x, mu, sigma, prop)

pnormmix(q, mu, sigma, prop)

qnormmix(p, mu, sigma, prop)
}
\arguments{
\item{n}{\link[base]{integer} value, the number of random samples to be
generated with \code{rnormmix()}.}

\item{mu}{\link[base]{numeric} \link[base]{vector} holding the means of the components.}

\item{sigma}{\link[base]{numeric} \link[base]{vector} holding the standard
deviations of the components.}

\item{prop}{\link[base]{numeric} \link[base]{vector}, holding the mixing proportions
of the components.}

\item{x}{\link[base]{numeric} \link[base]{vector} giving the points where
the density function is evaluated.}

\item{q}{\link[base]{numeric} \link[base]{vector} giving the quantiles where
the distribution function is evaluated.}

\item{p}{\link[base]{numeric} \link[base]{vector} giving the probabilities where
the quantile function is evaluated.}
}
\value{
\itemize{
\item \code{dnormmix()} gives a \link[base]{vector} of length \code{length(x)}
 containing the density at \code{x}.
\item \code{pnormmix()} gives a
\link[base]{vector} of length \code{length(q)} containing
the distribution function at the corresponding values of \code{q}.
\item \code{qnormmix()} gives a \link[base]{vector} of length \code{length(p)}
containing the quantiles at the corresponding values of \code{p}.
\item \code{rnormmix()} generates a \link[base]{vector} of length \code{n}
containing the random samples.
}
}
\description{
The number of components in the mixed normal distribution is specified by the length
of the parameter vectors. The quantiles are numerically obtained from the distribution function using
monotone cubic splines.
}
\examples{

rnormmix(10, mu = c(0, 3, 7), sigma = c(2, 2, 4), prop = c(0.6, 0.3, 0.1))

dnormmix(c(0, 2, 1), mu = c(0, 3), sigma = c(2, 2), prop = c(0.6, 0.4))

prob <- pnormmix(c(0.1, 7), mu = c(0, 3, 7), sigma = c(2, 2, 4), prop = c(0.6, 0.3, 0.1))
prob
qnormmix(prob, mu = c(0, 3, 7), sigma = c(2, 2, 4), prop = c(0.6, 0.3, 0.1))

}
