% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.run.EMIBD9.R
\name{gl.run.EMIBD9}
\alias{gl.run.EMIBD9}
\title{Run program EMIBD9}
\usage{
gl.run.EMIBD9(
  x,
  outfile = "EMIBD9_Res.ibd9",
  outpath = tempdir(),
  emibd9.path = getwd(),
  Inbreed = FALSE,
  palette_convergent = NULL,
  parallel = FALSE,
  ncores = 1,
  ISeed = 42,
  plot.out = TRUE,
  plot.dir = NULL,
  plot.file = NULL,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{outfile}{A string, giving the path and name of the output file
[default "EMIBD9_Res.ibd9"].}

\item{outpath}{Path where to save the output file. Use outpath=getwd() or
outpath='.' when calling this function to direct output files to your working
or current directory [default tempdir(), mandated by CRAN].}

\item{emibd9.path}{Path to the folder emidb files.
Please note there are 2 different executables depending on your OS:
EM_IBD_P.exe (=Windows) EM_IBD_P (=Mac, Linux).
You only need to point to the folder (the function will recognise which OS 
you are running) [default getwd()].}

\item{Inbreed}{A Boolean, taking values TRUE or FALSE to indicate inbreeding 
is not and is allowed in estimating IBD coefficients [default FALSE].}

\item{palette_convergent}{A continuous palette function for the relatedness 
values [default NULL].}

\item{parallel}{Use parallelisation[default FALSE].}

\item{ncores}{How many cores should be used [default 1].}

\item{ISeed}{An integer used to seed the random number generator 
[default 42].}

\item{plot.out}{A boolean that indicates whether to plot the results 
[default TRUE].}

\item{plot.dir}{Directory to save the plot RDS files [default as specified
by the global working directory or tempdir()]}

\item{plot.file}{Name for the RDS binary file to save (base name only, 
exclude extension) [default NULL]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
 [default NULL, unless specified using gl.set.verbosity]}
}
\value{
A matrix with pairwise relatedness
}
\description{
Run program EMIBD9
}
\details{
The results of EMIBD9 include the identical in state (IIS) values for each
 mode (S1 - 9) and nine condensed identical by descent (IBD) modes (\eqn{\delta}1 - \eqn{\delta}9) 
 as well as the relatedness coefficient (r). Alleles are IIS if they are the
  same. Similarly, IBD describes a matching allele between two individuals 
  that has been inherited from a common ancestor or common gene. In a 
  pairwise comparison, \eqn{\delta} 1 to \eqn{\delta} 9 are the probabilities associated with each 
  IBD mode. In inbreeding populations, only  \eqn{\delta} 1 to  \eqn{\delta} 6 can can occur. In
   contrast, \eqn{\delta} 7 to \eqn{\delta} 9 can only occur in large, panmictic outbred populations.

EMIBD9 uses an expectation maximization (EM) algorithm based on the maximum
likelihood expectations (MLE) of \eqn{\delta} to estimate both allele frequencies (p) 
and \eqn{\delta} jointly from genotype data. By iteratively calculating p and \eqn{\delta}, 
relatedness can be modified to reduce biases due to small sample sizes. 
Wang J. (2022) suggest the resulting r coefficient is therefore more robust 
compared to previous methods.

The kinship coefficient is the probability that two alleles at a random locus
 drawn from two individuals are IBD.

Below is a table modified from Speed & Balding (2015) showing kinship values,
and their confidence intervals (CI), for different relationships that could
be used to guide the choosing of the relatedness threshold in the function.

|Relationship                               |Kinship  |     95% CI       |

|Identical twins/clones/same individual     | 0.5     |        -         |

|Sibling/Parent-Offspring                   | 0.25    |    (0.204, 0.296)|

|Half-sibling                               | 0.125   |    (0.092, 0.158)|

|First cousin                               | 0.062   |    (0.038, 0.089)|

|Half-cousin                                | 0.031   |    (0.012, 0.055)|

|Second cousin                              | 0.016   |    (0.004, 0.031)|

|Half-second cousin                         | 0.008   |    (0.001, 0.020)|

|Third cousin                               | 0.004   |    (0.000, 0.012)|

|Unrelated                                  | 0       |        -         |

For greater detail on the methods employed by EMIBD9, we encourage you to 
read Wang, J. (2022).

Download the program from here:

https://www.zsl.org/about-zsl/resources/software/emibd9

For Windows, Mac and Linux install the program then point to the folder
 where you find: EM_IBD_P.exe (=Windows) and EM_IBD_P (=Mac, Linux). If 
 running really slow you may want to create the files using the function 
 and then run in parallel using the documentation provided by the authors
  [you need to have mpiexec installed].
}
\examples{
\dontrun{
#To run this function needs EMIBD9 installed in your computer
t1 <- gl.filter.allna(platypus.gl)
res_rel <- gl.run.EMIBD9(t1)
}

}
\references{
\itemize{
\item Wang, J. (2022). A joint likelihood estimator of relatedness and allele
 frequencies from a small sample of individuals. Methods in Ecology and
 Evolution, 13(11), 2443-2462.
}
}
\author{
Custodian: Luis Mijangos -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
