% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publication_year.R
\name{publication_year}
\alias{publication_year}
\alias{publication_year<-}
\title{Get or Set the Publication Year of a Dataset Object}
\usage{
publication_year(x)

publication_year(x, overwrite = TRUE) <- value
}
\arguments{
\item{x}{A dataset object created by \code{\link[=dataset_df]{dataset_df()}} or
\code{dataset::as_dataset_df()}.}

\item{overwrite}{Logical. If \code{TRUE} (default), the existing
\code{publication_year} attribute is replaced with \code{value}. If \code{FALSE}, the
function returns a message and does not overwrite the existing value.}

\item{value}{A character string specifying the publication year.}
}
\value{
The \code{publication_year} attribute as a character string.
}
\description{
Access or assign the optional \code{publication_year} attribute to a semantically
rich dataset object.
}
\details{
The \code{publication_year} represents the year when the dataset was or will be
made publicly available, in \code{YYYY} format. For additional context, see
\href{https://support.datacite.org/docs/datacite-metadata-schema-v44-mandatory-properties#publicationyearadditional-guidance}{DataCite: Publication Year-Additional Guidance}.
}
\examples{
publication_year(orange_df)
publication_year(orange_df) <- "1998"

}
\seealso{
Other bibliographic helper functions: 
\code{\link{contributor}()},
\code{\link{creator}()},
\code{\link{dataset_format}()},
\code{\link{dataset_title}()},
\code{\link{description}()},
\code{\link{geolocation}()},
\code{\link{get_bibentry}()},
\code{\link{language}},
\code{\link{publisher}()},
\code{\link{relation}()},
\code{\link{rights}()},
\code{\link{subject}()}
}
\concept{bibliographic helper functions}
